﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_SetupOverlayMovieThumbnail.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "action/visrv_DownsampleForOverlayThumbnailFromImageBufferNv12.h"
#include "action/visrv_SetOverlayMovieThumbnail.h"
#if defined(NN_CAPSRV_DEBUG_SEND_SCREENSHOT_OVLN_IN_MOVIE_THUMB_CREATION)
#include "action/visrv_SetOverlayScreenShotThumbnail.h"
#include "action/visrv_NotifyScreenShotResultToOverlayDisp.h"
#endif

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    nn::Result SetupOverlayMovieThumbnail(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_RESULT_DO(action::DownsampleForOverlayThumbnailFromImageBufferNv12(context));
        NN_RESULT_DO(action::SetOverlayMovieThumbnail(context));

#if defined(NN_CAPSRV_DEBUG_SEND_SCREENSHOT_OVLN_IN_MOVIE_THUMB_CREATION)
        context.SetResult(nn::ResultSuccess());
        context.SetFileSize(0);
        NN_RESULT_DO(action::SetOverlayScreenShotThumbnail(context));
        NN_RESULT_DO(action::NotifyScreenShotReultToOverlayDisp(context));
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(3));
#endif

        NN_RESULT_SUCCESS;
    }

}}}}
