﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/time/time_PosixTime.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>

#include "../jpeg/visrv_SoftwareJpegEncoderRgba8.h"
#include "../jpeg/visrv_SoftwareJpegEncoderYuv.h"

#include "../album/capsrvServer_AlbumManager.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{
    class AlbumManager;
}}}}

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    struct TimestampStatus
    {
        nn::time::PosixTime time;
        int id;
    };

    class ScreenShotUtility
    {
    public:
        static nn::Result GetCurrentTimestamp(AlbumFileDateTime* pOutValue, TimestampStatus* pStatus) NN_NOEXCEPT;
        static nn::Result GetAutoSavingStorage(AlbumStorageType* pOutValue, album::AlbumManager* pAlbumManager) NN_NOEXCEPT;

        static nn::Result GetCurrentAutoSavingFileId(
            AlbumFileId* pOutValue,
            nn::ncm::ApplicationId applicationId,
            AlbumFileContentsType contents,
            TimestampStatus* pStatus,
            album::AlbumManager* pAlbumManager
        ) NN_NOEXCEPT;

    // Encode
    public:
        static nn::Result EncodeRgba8BufferToBuffer(
            jpeg::SoftwareJpegEncoderBufferOutputInfo& outputInfo,
            const jpeg::SoftwareJpegEncoderBufferInputInfoRgba8& info,
            nn::image::ExifBuilder* pExifBuilder,
            void* pWorkBuffer,
            size_t workBufferSize
        ) NN_NOEXCEPT;

        static nn::Result EncodeYuvStreamToBuffer(
            jpeg::SoftwareJpegEncoderBufferOutputInfo& outputInfo,
            const jpeg::SoftwareJpegEncoderStreamInputInfoYuv& inputInfo,
            nn::image::ExifBuilder* pExifBuilder,
            void* pWorkBuffer,
            size_t workBufferSize
        ) NN_NOEXCEPT;

    };

}}}}
