﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/fbshare/vi_SharedMemoryPoolLayout.h>
#include "../../capture/capsrv_MemoryPool.h"
#include "../../capture/capsrv_ImageBuffer.h"
#include "../../capture/capsrv_DisplayBuffer.h"
#include "../../capture/capsrv_DisplayCapture.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    class CaptureModuleSharedTexture
    {
    public:
        CaptureModuleSharedTexture() NN_NOEXCEPT;

        void Initialize(
            capture::CaptureModule* pModule,
            const char* captureName
        ) NN_NOEXCEPT;

        // NOTE:
        // オブジェクトは即時破棄されるが MemoryPool がデバイスマップされた状態で残っている可能性がある。
        // 今の用途では Finalize() することはないし、システム共有のメモリプールしかアタッチしないので
        // 問題になることはないだろうということで、特に対処していない。
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;

        void AttachSharedMemoryPool(
            const capture::MemoryPoolImportData& src,
            const nn::vi::fbshare::SharedMemoryPoolLayout& layout
        ) NN_NOEXCEPT;

        // Detach は未実装。
        // VIC の処理中はドライバによって書込み先のバッファがデバイスマップされた状態にされる。
        // メモリプールを確実に破棄するためには VIC の完了を待つ必要がある。
        //void DetachSharedMemoryPool(NvRmFence* pOutFence) NN_NOEXCEPT;

        capture::DisplayBuffer* AcquireCaptureBuffer(int iBuf, nn::TimeSpan timeout, nn::vi::LayerStack layerStack) NN_NOEXCEPT;
        void ReleaseCaptureBuffer(capture::DisplayBuffer* pBuffer) NN_NOEXCEPT;

        bool IsRecoveryRequired() const NN_NOEXCEPT;
        bool RecoverCapture(nn::TimeSpan timeout) NN_NOEXCEPT;

    private:
        void ActivateBufferImpl(int iBuf) NN_NOEXCEPT;
        void DeactivateBufferImpl() NN_NOEXCEPT;

    private:
        capture::DisplayCapture m_Capture;
        capture::MemoryPool     m_MemoryPool;
        capture::ImageBuffer    m_ImageBuffer;
        capture::DisplayBuffer  m_DisplayBuffer;

        capture::CaptureModule* m_pModule;
        nn::vi::fbshare::SharedMemoryPoolLayout m_Layout;
        int m_CurrentBufferIndex;
    };

}}}}
