﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_AlbumControl.h>
#include <nn/capsrv/capsrv_AlbumFileSizeLimit.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // 画面写真ファイルをアルバムに保存する
    // @param[in]  context.AlbumFileId
    // @param[in]  context.FileDataMemory
    // @param[in]  context.FileSize
    static nn::Result SaveScreenShotFile(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, AlbumFileId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, FileSize);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, MakerNoteVersion);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, MakerNoteOffset);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, MakerNoteSize);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, FileDataMemory, AlbumFileSizeLimit_ScreenShot);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("save      ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pFileData, fileDataSize, context, FileDataMemory);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(fileId, context, AlbumFileId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(fileSize, context, FileSize);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(makerNoteVersion, context, MakerNoteVersion);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(makerNoteOffset, context, MakerNoteOffset);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(makerNoteSize, context, MakerNoteSize);
        //NN_SDK_LOG("fileSize: %lld\n", fileSize);

        NN_RESULT_DO(nn::capsrv::SaveAlbumScreenShotFile(fileId, pFileData, static_cast<size_t>(fileSize), makerNoteVersion, makerNoteOffset, makerNoteSize));
        NN_RESULT_SUCCESS;
    }

}}}}}
