﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/capsrv/capsrv_ViewerThumbnailFormat.h>

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // DisplayCapture から PhotoViewer 用のサムネイルを作成する
    // @param[in]  context.CaptureModule
    // @param[in]  context.DisplayBufferYuv
    // @param[out] context.ViewerThumbnailImageBuffer
    // @param[out] context.RawViewerThumbnailMemory
    static nn::Result DownsampleForViewerThumbnail(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, CaptureModule);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, DisplayBufferYuv);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, ViewerThumbnailImageBuffer);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawViewerThumbnailMemory, ViewerThumbnailImageDataSize_Raw);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("down pv   ");

        capture::Rectangle rect = capture::MakeRectangle(0, 0, ViewerThumbnailImageSize_Width, ViewerThumbnailImageSize_Height);
        capture::FilterMode filterMode = capture::FilterMode_Nicest;

        // VIC でコピー
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pModule, context, CaptureModule);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pDisplayBuffer, context, DisplayBufferYuv);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pThumbBuffer, context, ViewerThumbnailImageBuffer);
        pThumbBuffer->FlushCache();
        NN_RESULT_TRY(pDisplayBuffer->CopyToImageBuffer(pThumbBuffer, pModule, &rect, filterMode))
            NN_RESULT_CATCH_ALL
            {
                //NN_CAPSRV_LOG_ERR("Downsampling for viewer thumb failed\n");
                NN_RESULT_THROW(ResultScreenShotError());
            }
        NN_RESULT_END_TRY;

        // べた配列としてコピー
        {
            NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(buffer, bufferSize, context, RawViewerThumbnailMemory);
            size_t writtenSize = 0;
            NN_RESULT_TRY(pThumbBuffer->WriteToMemory(&writtenSize, buffer, ViewerThumbnailImageDataSize_Raw, capture::ImageFormat_Rgba8, &rect))
                NN_RESULT_CATCH_ALL
                {
                    //NN_CAPSRV_LOG_ERR("Writing viewer thumb to memory failed\n");
                    NN_RESULT_THROW(ResultScreenShotError());
                }
            NN_RESULT_END_TRY;
        }

        NN_RESULT_SUCCESS;
    }

}}}}}
