﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/capsrv/capsrv_ThumbnailFormat.h>
#include <nn/capsrv/capsrv_ViewerThumbnailFormat.h>
#include "../../detail/visrv_DownsampleImage.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // ViewerThumbnail からオーバーレイ用のサムネイルを作成する
    // @param[in]  context.RawViewerThumbnailMemory
    // @param[out] context.RawOverlayThumbnailMemory
    static nn::Result DownsampleForOverlayThumbnailFromViewerThumbnail(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawViewerThumbnailMemory, ViewerThumbnailImageDataSize_Raw);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawOverlayThumbnailMemory, ThumbnailImageDataSize_Default);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("pv -> ovl ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pViewerThumb, viewerThumbSize, context, RawViewerThumbnailMemory);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pOverlayThumb, overlayThumbSize, context, RawOverlayThumbnailMemory);

        detail::DownsampleImageRgbaBilinear(
            pOverlayThumb,
            overlayThumbSize,
            ThumbnailImageSize_Width,
            ThumbnailImageSize_Height,
            4 * ThumbnailImageSize_Width,
            pViewerThumb,
            viewerThumbSize,
            ViewerThumbnailImageSize_Width,
            ViewerThumbnailImageSize_Height,
            4 * ViewerThumbnailImageSize_Width,
            detail::DownsampleImageOption_Opaque
        );

        NN_RESULT_SUCCESS;
    }

}}}}}
