﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/capsrv/capsrv_ThumbnailFormat.h>
#include <nn/capsrv/capsrv_ViewerThumbnailFormat.h>
#include "../../../capture/capsrv_CopyImageBuffer.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // ImageBufferNv12 からオーバーレイ用のサムネイルを作成する
    // @param[in]  context.CaptureModule
    // @param[in]  context.ImageBufferNv12Y
    // @param[in]  context.ImageBufferNv12Uv
    // @param[out] context.OverlayThumbnailImageBuffer
    // @param[out] context.RawOverlayThumbnailMemory
    static nn::Result DownsampleForOverlayThumbnailFromImageBufferNv12(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, CaptureModule);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, ImageBufferNv12Y);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, ImageBufferNv12Uv);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, OverlayThumbnailImageBuffer);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawOverlayThumbnailMemory, ThumbnailImageDataSize_Default);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("yuv-> ovl ");

        // VIC でコピー
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pModule, context, CaptureModule);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pImgY, context, ImageBufferNv12Y);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pImgUv, context, ImageBufferNv12Uv);
        capture::Rectangle thumbRect = {};
        thumbRect.x = 0;
        thumbRect.y = 0;
        thumbRect.width = ThumbnailImageSize_Width;
        thumbRect.height = ThumbnailImageSize_Height;
        const capture::ImageBuffer* srcImageList[2] = {};
        srcImageList[0] = pImgY;
        srcImageList[1] = pImgUv;

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pThumbBuffer, context, OverlayThumbnailImageBuffer);
        pThumbBuffer->FlushCache();

        NN_RESULT_DO(capture::CopyImageBuffer(pModule, pThumbBuffer, thumbRect, srcImageList, 2, MovieWidth, MovieHeight, capture::FilterMode_Nicest));

        // べた配列としてコピー
        {
            NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(buffer, bufferSize, context, RawOverlayThumbnailMemory);
            size_t writtenSize = 0;
            NN_RESULT_TRY(pThumbBuffer->WriteToMemory(&writtenSize, buffer, ThumbnailImageDataSize_Default, capture::ImageFormat_Rgba8, &thumbRect))
                NN_RESULT_CATCH_ALL
                {
                    //NN_CAPSRV_LOG_ERR("Writing overlay thumb to memory failed\n");
                    NN_RESULT_THROW(ResultScreenShotError());
                }
            NN_RESULT_END_TRY;
        }

        NN_RESULT_SUCCESS;
    }

}}}}}
