﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include "../../capsrvServer_Config.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // DisplayCapture からメモリにコピーする
    // @param[in]  context.DisplayBufferRgba
    // @param[out] context.RawDisplayCaptureRgbaMemory
    static nn::Result CopyDisplayCaptureRgbaToMemory(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, DisplayBufferRgba);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawDisplayCaptureRgbaMemory, 4 * ScreenShotWidth * ScreenShotHeight);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("copy      ");


        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pDisplayBuffer, context, DisplayBufferRgba);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pMemory, memorySize, context, RawDisplayCaptureRgbaMemory);

        std::memset(pMemory, 0, memorySize);

        auto pImageBuffer = pDisplayBuffer->GetImageBuffer();
        NN_SDK_REQUIRES_NOT_NULL(pImageBuffer);

        auto rect = capture::MakeRectangle(0, 0, ScreenShotWidth, ScreenShotHeight);
        size_t writtenSize = 0;
        NN_RESULT_DO(pImageBuffer->WriteToMemory(&writtenSize, pMemory, memorySize, capture::ImageFormat_Rgba8, &rect));
        NN_RESULT_SUCCESS;
    }

}}}}}
