﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/util/util_ScopeExit.h>
#include "../../capsrvServer_Config.h"

#if defined(NN_CAPSRV_ENABLE_TIME_MEASURE)
#define NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE(tag)   \
    auto tick0 = nn::os::GetSystemTick();               \
    NN_UTIL_SCOPE_EXIT{                                 \
        auto tick1 = nn::os::GetSystemTick();           \
        auto time = (tick1 - tick0).ToTimeSpan().GetMicroSeconds(); \
        NN_CAPSRV_LOG_TIME(tag ": %lldus\n", time);     \
    };
#else
#define NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE(tag)
#endif
