﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_WriteJpegHeaderDataWithExif.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../capsrvServer_ResultPrivate.h"

#include <nn/image/image_ExifBuilder.h>
#include "../../../../../../Alice/Sources/Libraries/image/detail/image_JpegParser.h"

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    size_t GetJpegHeaderDataWithExifSize(nn::image::ExifBuilder* pExifBuilder) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pExifBuilder);

        size_t soiSize = 2;
        size_t exifHeaderSize = nn::image::detail::JpegProperty_ExifAppHeaderSize;
        size_t exifSize       = pExifBuilder->GetAnalyzedOutputSize();

        return soiSize + exifHeaderSize + exifSize;
    }

    nn::Result WriteJpegHeaderDataWithExif(
        void* pBuffer,
        size_t bufferSize,
        nn::image::ExifBuilder* pExifBuilder,
        int width,
        int height
    ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pBuffer);
        NN_SDK_REQUIRES_NOT_NULL(pExifBuilder);

        size_t soiSize = 2;
        size_t exifHeaderSize = nn::image::detail::JpegProperty_ExifAppHeaderSize;
        size_t exifSize       = pExifBuilder->GetAnalyzedOutputSize();

        size_t requiredSize = soiSize + exifHeaderSize + exifSize;

        NN_RESULT_THROW_UNLESS(bufferSize >= requiredSize, ResultInternalJpegOutBufferShortage());

        uint8_t* dst = reinterpret_cast<uint8_t*>(pBuffer);

        // Write SOI
        dst[0] = 0xFF;
        dst[1] = 0xD8;
        dst += soiSize;

        // Write Exif Header
        nn::image::detail::WriteExifHeader(dst, exifHeaderSize + exifSize);
        dst += exifHeaderSize;

        // Write Exif
        nn::image::Dimension dim;
        dim.width  = static_cast<int32_t>(width);
        dim.height = static_cast<int32_t>(height);
        pExifBuilder->Build(dst, exifSize, dim);
        dst += exifSize;

        NN_RESULT_SUCCESS;
    }



}}}}
