﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/image/image_ExifBuilder.h>
#include "visrv_SoftwareJpegEncoderInfo.h"

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    struct SoftwareJpegEncoderBufferInputInfoRgba8
    {
        int width;
        int height;

        const void* pImageData;
        size_t imageSize;
    };

    class SoftwareJpegEncoderRgba8
    {
    public:
        static const int ImageSizeHorizontalUnit = 16;
        static const int ImageSizeVerticalUnit = 8;

    public:
        // pExifBuilder は NULL でも良い
        static nn::Result EncodeRgba8BufferToBuffer(
            SoftwareJpegEncoderBufferOutputInfo& outputInfo,
            const SoftwareJpegEncoderBufferInputInfoRgba8& inputInfo,
            int quality,
            nn::image::ExifBuilder* pExifBuilder,
            void* pWorkBuffer,
            size_t workBufferSize
            ) NN_NOEXCEPT;

    private:
        static nn::Result EncodeRgba8BufferToBufferImpl(
            SoftwareJpegEncoderBufferOutputInfo& outputInfo,
            const SoftwareJpegEncoderBufferInputInfoRgba8& inputInfo,
            int quality,
            bool hasExif,
            void* pWorkBuffer,
            size_t workBufferSize
            ) NN_NOEXCEPT;
    };

}}}}
