﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_SoftwareJpegEncoderRgba8.h"

#include <csetjmp>

#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/image/image_JpegEncoder.h>
#include "../capsrvServer_Config.h"
#include "../capsrvServer_ResultPrivate.h"

#include "../../../../../../Alice/Sources/Libraries/image/detail/image_JpegParser.h"

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    nn::Result SoftwareJpegEncoderRgba8::EncodeRgba8BufferToBuffer(
        SoftwareJpegEncoderBufferOutputInfo& outputInfo,
        const SoftwareJpegEncoderBufferInputInfoRgba8& inputInfo,
        int quality,
        nn::image::ExifBuilder* pExifBuilder,
        void* pWorkBuffer,
        size_t workBufferSize
    ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(inputInfo.pImageData);

        if(pExifBuilder)
        {
            uint8_t* pApp1Buffer = reinterpret_cast<uint8_t*>(outputInfo.pBuffer);
            auto app1Size = pExifBuilder->GetAnalyzedOutputSize() + nn::image::detail::JpegProperty_ExifAppHeaderSize;
            NN_RESULT_THROW_UNLESS(
                outputInfo.bufferSize >= app1Size,
                ResultInternalJpegOutBufferShortage()
            );

            uint8_t* pDataBuffer = reinterpret_cast<uint8_t*>(outputInfo.pBuffer) + app1Size;
            size_t dataBufferSize = outputInfo.bufferSize - app1Size;

            size_t outSize = 0;
            SoftwareJpegEncoderBufferOutputInfo internalOutputInfo;
            internalOutputInfo.pOutSize   = &outSize;
            internalOutputInfo.pBuffer    = pDataBuffer;
            internalOutputInfo.bufferSize = dataBufferSize;
            NN_RESULT_DO(EncodeRgba8BufferToBufferImpl(internalOutputInfo, inputInfo, quality, true, pWorkBuffer, workBufferSize));

            NN_SDK_ASSERT(pDataBuffer[0] == 0xFF && pDataBuffer[1] == 0xD8);

            // copy SOI
            std::memcpy(pApp1Buffer, pDataBuffer, 2);

            // output exif
            nn::image::Dimension dim;
            dim.width  = static_cast<int32_t>(inputInfo.width);
            dim.height = static_cast<int32_t>(inputInfo.height);
            nn::image::detail::WriteExifHeader(pApp1Buffer + 2, app1Size);
            pExifBuilder->Build(
                pApp1Buffer + 2 + nn::image::detail::JpegProperty_ExifAppHeaderSize,
                pExifBuilder->GetAnalyzedOutputSize(),
                dim
            );

            outSize += app1Size;

            *outputInfo.pOutSize = outSize;
        }
        else
        {
            NN_RESULT_DO(EncodeRgba8BufferToBufferImpl(outputInfo, inputInfo, quality, false, pWorkBuffer, workBufferSize));
        }

        NN_RESULT_SUCCESS;
    }

    //nn::Result SoftwareJpegEncoderRgba8::EncodeRgba8BufferToStream(
    //    SoftwareJpegEncoderStreamOutputInfo& outputInfo,
    //    const SoftwareJpegEncoderBufferInputInfoRgba8& inputInfo,
    //    int quality,
    //    nn::image::ExifBuilder* pExifBuilder,
    //    void* pWorkBuffer,
    //    size_t workBufferSize
    //) NN_NOEXCEPT
    //{
    //    NN_SDK_REQUIRES_NOT_NULL(inputInfo.pImageData);
    //    bool isSuccess = false;
    //    auto bufferUnitRecoveryPoint = *outputInfo.pBufferUnitList;
    //    NN_UTIL_SCOPE_EXIT {
    //        if(!isSuccess)
    //        {
    //            outputInfo.pBufferAllocator->Revert(outputInfo.pBufferUnitList, bufferUnitRecoveryPoint);
    //        }
    //    };

    //    if(pExifBuilder)
    //    {
    //        int headIndex = outputInfo.pBufferAllocator->Allocate(outputInfo.pBufferUnitList);
    //        NN_RESULT_THROW_UNLESS(
    //            headIndex >= 0,
    //            ResultInternalJpegOutBufferShortage()
    //        );

    //        auto pHeadUnit = &outputInfo.pBufferUnitList->GetUnit(headIndex);
    //        NN_RESULT_THROW_UNLESS(
    //            pHeadUnit->pMemory != nullptr,
    //            ResultInternalJpegOutBufferShortage()
    //        );

    //        // ヘッダ部分を書き出し
    //        {
    //            uint8_t* pHeadMemory = reinterpret_cast<uint8_t*>(pHeadUnit->pMemory);
    //            size_t   unitSize    = pHeadUnit->size;

    //            // サイズ計算
    //            size_t soiSize = 2;
    //            size_t exifHeaderSize = nn::image::detail::JpegProperty_ExifAppHeaderSize;
    //            size_t exifSize = pExifBuilder->GetAnalyzedOutputSize();
    //            NN_SDK_ASSERT_GREATER_EQUAL(unitSize, soiSize + exifHeaderSize + exifSize);
    //            NN_UNUSED(unitSize);

    //            uint8_t* pApp1Buffer = pHeadMemory;

    //            // write SOI
    //            pApp1Buffer[0] = 0xFF;
    //            pApp1Buffer[1] = 0xD8;

    //            // write exif header
    //            nn::image::detail::WriteExifHeader(pApp1Buffer + soiSize, exifHeaderSize + exifSize);

    //            // output exif
    //            nn::image::Dimension dim;
    //            dim.width  = static_cast<int32_t>(inputInfo.width);
    //            dim.height = static_cast<int32_t>(inputInfo.height);
    //            pExifBuilder->Build(
    //                pApp1Buffer + soiSize + exifHeaderSize,
    //                exifSize,
    //                dim
    //            );

    //            pHeadUnit->usedSize = soiSize + exifHeaderSize + exifSize;
    //        }

    //        int dataTopIndex = outputInfo.pBufferUnitList->GetUnitCount();

    //        NN_RESULT_DO(EncodeRgba8BufferToStreamImpl(outputInfo, inputInfo, quality, true, pWorkBuffer, workBufferSize));

    //        // skip SOI of written data
    //        auto& dataTopUnit = outputInfo.pBufferUnitList->GetUnit(dataTopIndex);
    //        dataTopUnit.skipSize = 2;
    //    }
    //    else
    //    {
    //        NN_RESULT_DO(EncodeRgba8BufferToStreamImpl(outputInfo, inputInfo, quality, false, pWorkBuffer, workBufferSize));
    //    }

    //    isSuccess = true;
    //    NN_RESULT_SUCCESS;
    //}


}}}}
