﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <csetjmp>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include "../capsrvServer_Config.h"
#include "../capsrvServer_ResultPrivate.h"

#ifdef NN_CAPSRV_USE_LIBJPEG_TURBO
#include "capsrvServer_SoftwareJpegEncoderType-encoder.libjpegTurbo.h"
#else
#include "capsrvServer_SoftwareJpegEncoderType-encoder.libjpeg.h"
#endif

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    struct JpegErrorHandler
        : public JpegEncoderType::jpeg_error_mgr
    {
    public:
        // nn::image::detail::GetStatusCode と同様。ただし nn::Result を返す
        static nn::Result GetResult(int messageCode, int messageParam0) NN_NOEXCEPT
        {
            switch (messageCode)
            {
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_ALIGN_TYPE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_ALLOC_CHUNK:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_CROP_SPEC:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_BUFFER_MODE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_LIB_VERSION:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_POOL_ID:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_STATE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_STRUCT_SIZE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_VIRTUAL_ACCESS:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_FILE_READ:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_EMS_READ:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_EMS_WRITE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_FILE_WRITE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_XMS_READ:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_XMS_WRITE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_VIRTUAL_BUG:
                {
                    // WrongFormat
                    NN_RESULT_THROW(ResultInternalJpegEncoderError());
                }
            case JpegEncoderType::J_MESSAGE_CODE::JERR_NOTIMPL:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_NOT_COMPILED:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_FRACT_SAMPLE_NOTIMPL:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_CCIR601_NOTIMPL:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_CONVERSION_NOTIMPL:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_HUFF_CLEN_OVERFLOW:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_IMAGE_TOO_BIG:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_MISMATCHED_QUANT_TABLE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_SOF_UNSUPPORTED:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_UNKNOWN_MARKER:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_WIDTH_OVERFLOW:
                {
                    // UnsupportedFormat
                    NN_RESULT_THROW(ResultInternalJpegEncoderError());
                }
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_COMPONENT_ID:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_DCT_COEF:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_DCTSIZE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_DROP_SAMPLING:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_HUFF_TABLE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_IN_COLORSPACE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_J_COLORSPACE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_LENGTH:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_MCU_SIZE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_PRECISION:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_PROGRESSION:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_PROG_SCRIPT:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_SAMPLING:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BAD_SCAN_SCRIPT:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_CANT_SUSPEND:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_COMPONENT_COUNT:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_DAC_INDEX:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_DAC_VALUE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_DHT_INDEX:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_DQT_INDEX:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_EMPTY_IMAGE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_EOI_EXPECTED:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_HUFF_MISSING_CODE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_INPUT_EMPTY:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_INPUT_EOF:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_MISSING_DATA:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_MODE_CHANGE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_NO_ARITH_TABLE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_NO_HUFF_TABLE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_NO_IMAGE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_NO_QUANT_TABLE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_NO_SOI:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_QUANT_COMPONENTS:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_QUANT_FEW_COLORS:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_QUANT_MANY_COLORS:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_SOF_DUPLICATE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_SOF_NO_SOS:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_SOI_DUPLICATE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_SOS_NO_SOF:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_TOO_LITTLE_DATA:
                {
                    // WrongFormat
                    NN_RESULT_THROW(ResultInternalJpegEncoderError());
                }
            case JpegEncoderType::J_MESSAGE_CODE::JERR_OUT_OF_MEMORY:
                {
                    // メモリ不足 (エンコード時の出力バッファ不足対応込み)
                    if(messageParam0 == OUT_OF_MEM_REASON_OUTPUT)
                    {
                        // ShortOutput
                        NN_RESULT_THROW(ResultInternalJpegOutBufferShortage());
                    }
                    else
                    {
                        // OutOfMemory
                        NN_RESULT_THROW(ResultInternalJpegWorkMemoryShortage());
                    }
                }
            case JpegEncoderType::J_MESSAGE_CODE::JERR_BUFFER_SIZE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_NO_BACKING_STORE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_TFILE_CREATE:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_TFILE_READ:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_TFILE_SEEK:
            case JpegEncoderType::J_MESSAGE_CODE::JERR_TFILE_WRITE:
                {
                    // OutOfMemory
                    NN_RESULT_THROW(ResultInternalJpegWorkMemoryShortage());
                }
            default:
                {
                    //その他
                    NN_RESULT_THROW(ResultInternalJpegEncoderError());
                }
            }
        } // NOLINT(impl/function_size)


        static void HandleError(JpegEncoderType::jpeg_common_struct* pCinfo) NN_NOEXCEPT
        {
            JpegErrorHandler* pHandler = reinterpret_cast<JpegErrorHandler*>(pCinfo->err);
            if(pHandler->msg_code == JpegEncoderType::J_MESSAGE_CODE::JERR_OUT_OF_MEMORY && pHandler->msg_parm.i[0] == OUT_OF_MEM_REASON_OUTPUT)
            {
                //NN_CAPSRV_LOG_WARN("Jpeg Encoder fails with output buffer shortage\n");
            }
            else
            {
                NN_CAPSRV_LOG_ERR("Jpeg Encoder fails: %d(%d)\n", pHandler->msg_code, pHandler->msg_parm.i[0]);
            }
            pHandler->encoderResult = GetResult(pHandler->msg_code, pHandler->msg_parm.i[0]);
            longjmp(pHandler->jmpContext, -1);
        }

    public:
        std::jmp_buf jmpContext;
        nn::Result encoderResult;
    };

}}}}
