﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include "../capsrvServer_Config.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

#ifdef NN_CAPSRV_ENABLE_TIME_MEASURE

#define NN_CAPSRV_TIME_MEASURE_START(sectionName, variable) \
    nn::capsrv::server::detail::TimeMeasure variable;  \
    variable.name = sectionName;                            \
    variable.startTick = nn::os::GetSystemTick();

#define NN_CAPSRV_TIME_MEASURE_END(variable) \
    variable.endTick = nn::os::GetSystemTick();

#define NN_CAPSRV_TIME_MEASURE_REPORT(variable)  \
    [](const nn::capsrv::server::detail::TimeMeasure& v) -> void    \
    {                                                               \
        auto tick = v.endTick - v.startTick;                        \
        auto micro = tick.ToTimeSpan().GetMicroSeconds();           \
        NN_CAPSRV_LOG_TIME("%s: %.2f msec\n", v.name, static_cast<float>(micro) / 1000.f); \
        NN_UNUSED(tick);                                            \
        NN_UNUSED(micro);                                           \
    }(variable);                                                    \


    struct TimeMeasure
    {
        const char* name;
        nn::os::Tick startTick;
        nn::os::Tick endTick;
    };

#else

#define NN_CAPSRV_TIME_MEASURE_START(sectionName, variable)
#define NN_CAPSRV_TIME_MEASURE_END(variable)
#define NN_CAPSRV_TIME_MEASURE_REPORT(variable)

#endif


}}}}

