﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrvServer_MakerNoteInfo.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    // @brief MakerNote を解析します。
    // @param[out] pOutValue 解析結果を受け取る変数のポインタ
    // @param[in] pMakernoteData 解析対象の MakerNote のバイト列
    // @param[in] makerNoteDataSize 解析対象の MakerNote のバイト列の長さ
    // @pre pOutValue != nullptr
    // @pre pMakerNoteData != nullptr
    // @pre makerNoteData > 0
    // @retval nn::ResultSuccess 解析に成功
    // @retval nn::capsrv::ResultAlbumInvalidFileData 解析に失敗
    // @details
    //   解析に失敗した場合、 *pOutValue の値は変更されません。
    nn::Result TryParseMakerNote(
        MakerNoteInfo* pOutValue,
        const void* pMakerNoteData,
        size_t makerNoteDataSize
        ) NN_NOEXCEPT;

}}}}
