﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrvServer_EncryptMakerNote.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    enum MakerNoteEncryptionVersion
    {
        // 難読化なし
        MakerNoteEncryptionVersion_None,

        // 難読化あり
        MakerNoteEncryptionVersion_Version1,
    };

    struct MakerNoteEncryptionPolicyNoEncryption
    {
        static const int Version = MakerNoteEncryptionVersion_None;
        static const size_t UnitSize    = 1;

        static void EncryptInplace(void*, size_t, ptrdiff_t) NN_NOEXCEPT
        {
            return;
        }

        static void DecryptInplace(void*, size_t, ptrdiff_t) NN_NOEXCEPT
        {
            return;
        }
    };

    struct MakerNoteEncryptionPolicyV1
    {
        static const int Version = MakerNoteEncryptionVersion_Version1;
        static const size_t UnitSize = 32;

        static void EncryptInplace(void* buffer, size_t size, ptrdiff_t startOffset) NN_NOEXCEPT
        {
            EncryptMakerNoteInplaceVersion1(buffer, size, startOffset);
        }

        static void DecryptInplace(void* buffer, size_t size, ptrdiff_t startOffset) NN_NOEXCEPT
        {
            DecryptMakerNoteInplaceVersion1(buffer, size, startOffset);
        }
    };

}}}}
