﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_StringUtil.h>
#include <nn/capsrv/capsrv_AlbumEntry.h>
#include <nn/capsrv/capsrv_ApplicationAlbumEntry.h>

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    struct ApplicationAlbumEntryKey
    {
    public:
        static ApplicationAlbumEntryKey GetInvalidValue() NN_NOEXCEPT
        {
            ApplicationAlbumEntryKey value = {};
            return value;
        }

        bool operator==(const ApplicationAlbumEntryKey& v) const NN_NOEXCEPT
        {
            return nn::util::Strncmp(this->value, v.value, static_cast<int>(sizeof(this->value))) == 0;
        }

        bool operator!=(const ApplicationAlbumEntryKey& v) const NN_NOEXCEPT
        {
            return !(*this == v);
        }

    public:
        char value[32];
    };

    ApplicationAlbumEntry GetApplicationAlbumEntryFromAlbumEntry(const AlbumEntry& src, const ApplicationAlbumEntryKey& key) NN_NOEXCEPT;

    AlbumEntry GetAlbumEntryFromApplicationAlbumEntry(const ApplicationAlbumEntry& src, const ApplicationAlbumEntryKey& key) NN_NOEXCEPT;

}}}}
