﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "capsrvServer_Signature.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    // @brief JPEG のファイルデータから MakerNote の範囲を取得します。
    // @param[out] pOutOffset     MakerNote 部分の開始位置を受け取る変数
    // @param[out] pOutSize       MakerNote 部分の大きさを受け取る変数
    // @param[in]  pJpegData      JPEG ファイルデータ
    // @param[in]  jpegDataSize   JPEG ファイルデータの大きさ（バイト）
    // @param[in]  pWorkMemory    ワークメモリ
    // @param[in]  workMemorySize ワークメモリの大きさ（バイト）
    // @pre pOutOffset != nullptr
    // @pre pOutSize != nullptr
    // @pre pJpegData != nullptr
    // @pre pWorkMemory != nullptr
    // @pre pWorkMemory % alignof(std::max_align_t) == 0
    // @pre workMemorySize >= nn::image::ExifExtractor::GetWorkBufferSize()
    nn::Result ExtractJpegMakerNoteRange(
        int64_t* pOutOffset,
        int64_t* pOutSize,
        const void* pJpegData,
        size_t jpegDataSize,
        void* pWorkMemory,
        size_t workMemorySize
        ) NN_NOEXCEPT;

}}}}
