﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_EncryptMakerNote.h"

#include "capsrvServer_MakerNoteInfo.h"
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/crypto/crypto_Aes128CtrEncryptor.h>
#include <nn/crypto/crypto_Aes128CtrDecryptor.h>

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    namespace {

        typedef nn::crypto::Aes128CtrEncryptor Encryptor;
        typedef nn::crypto::Aes128CtrDecryptor Decryptor;
        static const size_t KeySize = 16;
        static const size_t IvSize  = 16;

        // 難読化が目的なので鍵はここに書いておく。
        const uint8_t MakerNoteEncryptionKey[KeySize] = {
            0xF8, 0x4F, 0x53, 0x91, 0xDB, 0x67, 0xC2, 0x09, 0x36, 0xE4, 0x51, 0xCD, 0xCC, 0xA1, 0xA0, 0x41,
        };

        const uint8_t MakerNoteEncryptionIv[IvSize] = {
            0x34, 0x62, 0xBD, 0x0E, 0xBE, 0x71, 0x82, 0x74, 0x28, 0xB9, 0x7C, 0x3B, 0x29, 0xBF, 0xDF, 0x97,
        };

    }

    void EncryptMakerNoteInplaceVersion1(void* buffer, size_t bufferSize, ptrdiff_t startOffset) NN_NOEXCEPT
    {
        typedef MakerNoteEncryptionPolicyV1 Policy;
        NN_SDK_REQUIRES_GREATER_EQUAL(startOffset, 0);
        NN_SDK_REQUIRES_LESS(startOffset, bufferSize);
        NN_SDK_REQUIRES_EQUAL((bufferSize - startOffset) % Policy::UnitSize, 0);

        const int BlockSize = Encryptor::BlockSize;
        NN_STATIC_ASSERT(Policy::UnitSize % BlockSize == 0);
        NN_STATIC_ASSERT(IvSize == Encryptor::IvSize);

        Encryptor encryptor;
        encryptor.Initialize(MakerNoteEncryptionKey, sizeof(MakerNoteEncryptionKey), MakerNoteEncryptionIv, sizeof(MakerNoteEncryptionIv));

        auto p = reinterpret_cast<char*>(buffer) + startOffset;
        ptrdiff_t remain = bufferSize - startOffset;
        while(remain > 0)
        {
            // in-place で実行できるように一旦テンポラリに書く
            char tmp[BlockSize] = {};
            encryptor.Update(tmp, BlockSize, p, BlockSize);
            std::memcpy(p, tmp, BlockSize);
            p += BlockSize;
            remain -= BlockSize;
        }
        NN_SDK_REQUIRES_EQUAL(remain, 0);
    }

    void DecryptMakerNoteInplaceVersion1(void* buffer, size_t bufferSize, ptrdiff_t startOffset) NN_NOEXCEPT
    {
        typedef MakerNoteEncryptionPolicyV1 Policy;
        NN_SDK_REQUIRES_GREATER_EQUAL(startOffset, 0);
        NN_SDK_REQUIRES_LESS(startOffset, bufferSize);
        NN_SDK_REQUIRES_EQUAL((bufferSize - startOffset) % Policy::UnitSize, 0);

        const int BlockSize = Decryptor::BlockSize;
        NN_STATIC_ASSERT(Policy::UnitSize % BlockSize == 0);
        NN_STATIC_ASSERT(IvSize == Decryptor::IvSize);

        Decryptor decryptor;
        decryptor.Initialize(MakerNoteEncryptionKey, sizeof(MakerNoteEncryptionKey), MakerNoteEncryptionIv, sizeof(MakerNoteEncryptionIv));

        auto p = reinterpret_cast<char*>(buffer) + startOffset;
        ptrdiff_t remain = bufferSize - startOffset;
        while(remain > 0)
        {
            // in-place で実行できるように一旦テンポラリに書く
            char tmp[BlockSize] = {};
            decryptor.Update(tmp, BlockSize, p, BlockSize);
            std::memcpy(p, tmp, BlockSize);
            p += BlockSize;
            remain -= BlockSize;
        }
        NN_SDK_REQUIRES_EQUAL(remain, 0);
    }

}}}}

