﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/capsrv/capsrv_ApplicationAlbumEntry.h>
#include <nn/capsrv/capsrv_AlbumEntry.h>

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    // ApplicationAlbumEntry を復号して AlbumEntry を返す。
    // 対象ファイルの applicationId が一致しない場合は NotFound を返す。
    Result DecryptApplicationAlbumEntryAndCheckApplicationId(AlbumEntry* pOutEntry, const ApplicationAlbumEntry& srcEntry, const ncm::ApplicationId& applicationId) NN_NOEXCEPT;

}}}}
