﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <random>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/ncm/ncm_ContentMeta.h>

#include "../capsrvServer_Config.h"
#include <nn/capsrv/capsrv_AlbumEntry.h>
#include "../detail/capsrvServer_GetApplicationAlbumEntry.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    class ApplicationResourceManager;

    class ApplicationResource
    {
    public:
        ApplicationResource() NN_NOEXCEPT;

        void Initialize(
            nn::applet::AppletResourceUserId aruid,
            nn::ncm::ApplicationId applicationId
        ) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;

        nn::applet::AppletResourceUserId GetAruid() const NN_NOEXCEPT;
        nn::ncm::ApplicationId           GetApplicationId() const NN_NOEXCEPT;

        const ApplicationAlbumEntryKey& GetApplicationAlbumEntryKey() const NN_NOEXCEPT;
    private:
        void InitializeApplicationAlbumEntryKey() NN_NOEXCEPT;
        void FinalizeApplicationAlbumEntryKey() NN_NOEXCEPT;

    private:
        bool                             m_IsInitialized;
        nn::applet::AppletResourceUserId m_Aruid;
        nn::ncm::ApplicationId           m_ApplicationId;

        // ApplicationAlbumEntry
        ApplicationAlbumEntryKey m_ApplicationAlbumEntryKey;
    };

    class ApplicationResourceManager
    {
    public:
        ApplicationResourceManager() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::Result Register(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        void Unregister(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result GetApplicationIdFromAruid(nn::ncm::ApplicationId* pOutApplicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CheckApplicationIdRegistered(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;

        nn::Result GetApplicationAlbumEntryKeyFromApplicationId(ApplicationAlbumEntryKey* pOutValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result GetApplicationAlbumEntryKeyFromAruid(ApplicationAlbumEntryKey* pOutValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

    private:
        nn::Result GetApplicationResourceFromApplicationIdImpl(ApplicationResource** pOutValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result GetApplicationResourceFromAruidImpl(ApplicationResource** pOutValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

    private:
        friend class ApplicationResource;
        bool m_IsInitialized;
        nn::os::SdkMutexType m_Mutex;
        ApplicationResource m_ApplicationResourceList[ApplicationCountMax];

        std::mt19937_64 m_Rand;
    };

}}}}
