﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{ namespace server{

    typedef uint64_t ResourceIdType;

    class ResourceIdManager
    {
    public:
        static ResourceIdType GetInvalidResourceId() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        ResourceIdType AcquireResourceId() NN_NOEXCEPT;
        void ReleaseResourceId(ResourceIdType id) NN_NOEXCEPT;

    private:
        std::atomic_uint64_t m_NextResourceId;
    };

}}}

#define NN_CAPSRV_RESOURCE_ID_DEFINITION(TypeName) \
    struct TypeName \
    {   \
    public: \
        static TypeName GetInvalidValue() { return TypeName(nn::capsrv::server::ResourceIdManager::GetInvalidResourceId()); } \
        TypeName() NN_NOEXCEPT : id(nn::capsrv::server::ResourceIdManager::GetInvalidResourceId()) {}   \
        explicit TypeName(nn::capsrv::server::ResourceIdType id) NN_NOEXCEPT : id(id) {} \
        bool operator==(const TypeName& v) const NN_NOEXCEPT { return this->id == v.id; }   \
        bool operator!=(const TypeName& v) const NN_NOEXCEPT { return this->id != v.id; }   \
    public: \
        nn::capsrv::server::ResourceIdType id;  \
    };

