﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_ThumbnailFormat.h>
#include "../capsrvServer_Config.h"

#define NN_CAPSRV_ALIGNAS_WORKMEMORY NN_ALIGNAS(4096)

namespace nn{ namespace capsrv{ namespace server{

    class AlbumWorkMemoryUtility
    {
    public:
        // @brief ワークメモリの単位サイズ。
        // @details
        //   ページサイズに一致させておく
        static const int UnitSize = 4 * 1024;

        // @brief 単位サイズまで切り上げる
        template<int N>
        struct RoundUpToUnitSize{
            enum { Value = ((N + UnitSize - 1) / UnitSize) * UnitSize };
        };

        // @brief 大きい方を選ぶ
        template<int A, int B>
        struct MaxOf{
            enum { Value = (A > B) ? A : B };
        };

    };

    enum AlbumWorkMemorySize
    {
        AlbumWorkMemorySize_AlbumManagerWorkBuffer = AlbumManagerWorkBufferSize,

        AlbumWorkMemorySize_OverlayThumbnailHolderMemory =
            OverlayThumbnailImageCount * AlbumWorkMemoryUtility::RoundUpToUnitSize<ThumbnailImageDataSize_Default>::Value,
    };

    enum AlbumWorkMemoryAlignment
    {
        AlbumWorkMemoryAlignment_Default = 4096,
    };

    struct AlbumWorkMemory
    {
        NN_CAPSRV_ALIGNAS_WORKMEMORY char albumManagerMemory          [AlbumWorkMemorySize_AlbumManagerWorkBuffer];
        NN_CAPSRV_ALIGNAS_WORKMEMORY char overlayThumbnailHolderMemory[AlbumWorkMemorySize_OverlayThumbnailHolderMemory];
    };

}}}
