﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_IServiceObject.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/applet/applet_Types.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>
#include <nn/capsrv/capsrv_ApplicationAlbumFileEntry.h>
#include <nn/capsrv/capsrv_AlbumAccessForApplication.h>

namespace nn { namespace capsrv { namespace server {

class AlbumApplicationServiceImpl
{
public:
    Result GetAlbumFileListEx0ByAruid(nn::sf::Out<uint64_t> pOutCount, const nn::sf::OutArray<ApplicationAlbumFileEntry>& pOutList, AlbumFileContentsType contents, AlbumFileDateTime beginDateTime, AlbumFileDateTime endDateTime, applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    Result GetAlbumFileListEx1ByAruid(nn::sf::Out<uint64_t> pOutCount, const nn::sf::OutArray<ApplicationAlbumFileEntry>& pOutList, AlbumFileContentsType contents, const account::Uid& uid, AlbumFileDateTime beginDateTime, AlbumFileDateTime endDateTime, applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    Result GetAlbumFileListByAruid(nn::sf::Out<uint64_t> pOutCount, const nn::sf::OutArray<ApplicationAlbumFileEntry>& pOutList, AlbumFileContentsType contents, int64_t beginPosixTime, int64_t endPosixTime, applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    Result DeleteAlbumFileByAruid(const ApplicationAlbumFileEntry& srcEntry, AlbumFileContentsType contents, applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    Result DeleteAlbumFileByAruidForDebug(const ApplicationAlbumFileEntry& srcEntry, applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    Result GetAlbumFileSizeByAruid(nn::sf::Out<uint64_t> outSize, const ApplicationAlbumFileEntry& entry, applet::AppletResourceUserId aruid) NN_NOEXCEPT;

    Result LoadAlbumScreenShotImageByAruid(nn::sf::Out<sf::LoadAlbumScreenShotImageOutputForApplication> pOut, nn::sf::OutBuffer outBuffer, const ApplicationAlbumFileEntry& entry, const ScreenShotDecodeOption& option, nn::sf::OutBuffer workBuffer, applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    Result LoadAlbumScreenShotThumbnailImageByAruid(nn::sf::Out<sf::LoadAlbumScreenShotImageOutputForApplication> pOut, nn::sf::OutBuffer outBuffer, const ApplicationAlbumFileEntry& entry, const ScreenShotDecodeOption& option, nn::sf::OutBuffer workBuffer, applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    Result PrecheckToCreateContentsByAruid(AlbumFileContentsType contents, uint64_t size, applet::AppletResourceUserId aruid) NN_NOEXCEPT;

    // セッション作成
    Result OpenAccessorSessionForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
};

}}} // namespace nn::capsrv::server
