﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_AlbumAccessorSessionFactory.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn{ namespace capsrv{ namespace server{

    nn::Result AlbumAccessorSessionFactory::Create(nn::sf::SharedPointer<sf::IAlbumAccessorSession>* pOutValue) NN_NOEXCEPT
    {
        auto p = nn::sf::CreateSharedObjectEmplaced<nn::capsrv::sf::IAlbumAccessorSession, AlbumAccessorSessionImpl>();
        NN_RESULT_THROW_UNLESS(p != nullptr, ResultInternalAlbumSessionCountLimit());
        *pOutValue = p;
        NN_RESULT_SUCCESS;
    }

    nn::Result AlbumAccessorSessionFactory::Create(nn::sf::SharedPointer<sf::IAlbumAccessorApplicationSession>* pOutValue) NN_NOEXCEPT
    {
        auto p = nn::sf::CreateSharedObjectEmplaced<nn::capsrv::sf::IAlbumAccessorApplicationSession, AlbumAccessorApplicationSessionImpl>();
        NN_RESULT_THROW_UNLESS(p != nullptr, ResultInternalAlbumSessionCountLimit());
        *pOutValue = p;
        NN_RESULT_SUCCESS;
    }

}}}

