﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_Types.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>
#include "../capsrvServer_Config.h"
#include "../capsrvServer_SessionId.h"
#include "../album/capsrvServer_MovieStreamIdTable.h"

namespace nn{ namespace capsrv{ namespace server{

    class AlbumAccessorApplicationSessionImpl
    {
    public:
        explicit AlbumAccessorApplicationSessionImpl() NN_NOEXCEPT;
        ~AlbumAccessorApplicationSessionImpl() NN_NOEXCEPT;

    private:
        SessionId m_SessionId;

    // @name IAlbumAccessorApplicationSession
    // @{
    public:
        nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;

    private:
        nn::Result CloseAllAlbumMovieReadStreams() NN_NOEXCEPT;

    private:
        album::MovieStreamIdTable<MovieReadStreamCountMax> m_MovieReadStreamIdTable;
    // @}

    };

}}}
