﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrvServer_AlbumMovieUtility.h"
#include "capsrvServer_AlbumFileManipulator.h"
#include "capsrvServer_TemporaryFileManipulator.h"
#include "../capsrvServer_EnvironmentInfo.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    nn::Result VerifyMovieFileSignAndMeta(
        int64_t* pOutMovieDataBlockCount,
        int64_t* pOutMovieDataOffset,
        int64_t* pOutMovieDataSize,
        int64_t* pOutImageDataOffset,
        int64_t* pOutImageDataSize,
        AlbumMovieUtility::MetaHashList* pOutMetaHashList,
        const AlbumFileHandle& hFile,
        int64_t fileSize,
        const TemporaryFileHandle& hHashFile,
        const EnvironmentInfo& env,
        void* workMemory,
        size_t workMemorySize
    ) NN_NOEXCEPT;

    nn::Result VerifyMovieFileAndLoadImage(
        size_t* pOutSize,
        int64_t* pOutImageDataSize,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileHandle& hFile,
        int64_t fileSize,
        const EnvironmentInfo& env,
        void* workMemory,
        size_t workMemorySize
    ) NN_NOEXCEPT;

}}}}
