﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    class TemporaryFileManipulator;

    class TemporaryFileHandle
    {
        friend class TemporaryFileManipulator;

    public:
        // TM:/0123456789ABCDEF\0
        static const size_t PathSize = 21;

    public:
        TemporaryFileHandle() NN_NOEXCEPT;

    private:
        nn::fs::FileHandle m_Handle;
        char m_Path[PathSize];
    };

    class TemporaryFileManipulator
    {
    public:

        static nn::Result OpenNewTemporaryFile(
            TemporaryFileHandle* pOutHandle,
            int64_t initialFileSize
        ) NN_NOEXCEPT;

        static void DiscardTemporaryFile(
            const TemporaryFileHandle& handle
        ) NN_NOEXCEPT;

        static nn::Result GetFileSize(int64_t* pOutValue, const TemporaryFileHandle& handle) NN_NOEXCEPT;
        static nn::Result ReadFile(size_t* pOutReadSize, const TemporaryFileHandle& handle, int64_t offset, void* buffer, size_t size) NN_NOEXCEPT;
        static nn::Result WriteFile(const TemporaryFileHandle& handle, int64_t offset, const void* buffer, size_t size) NN_NOEXCEPT;
        static nn::Result ResizeFile(const TemporaryFileHandle& handle, int64_t size) NN_NOEXCEPT;
    };

}}}}
