﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../capsrvServer_ResultPrivate.h"
#include "capsrvServer_MovieStreamManager.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    template<int TCapacity>
    class MovieStreamIdTable
    {
    public:
        static const int Capacity = TCapacity;
        typedef MovieStreamId ValueType;

    public:
        void Initialize() NN_NOEXCEPT
        {
            for(int i = 0; i < Capacity; i++)
            {
                m_Table[i] = ValueType::GetInvalidValue();
            }
        }

        void Finalize() NN_NOEXCEPT
        {
            for(int i = 0; i < Capacity; i++)
            {
                m_Table[i] = ValueType::GetInvalidValue();
            }
        }

        bool IsFull() const NN_NOEXCEPT
        {
            for(int i = 0; i < Capacity; i++)
            {
                if(m_Table[i] == ValueType::GetInvalidValue())
                {
                    return false;
                }
            }
            return true;
        }

        // @pre value != InvalidValue
        nn::Result Register(ValueType value) NN_NOEXCEPT
        {
            NN_SDK_REQUIRES_NOT_EQUAL(value, ValueType::GetInvalidValue());
            for(int i = 0; i < Capacity; i++)
            {
                if(m_Table[i] == ValueType::GetInvalidValue())
                {
                    m_Table[i] = value;
                    NN_RESULT_SUCCESS;
                }
            }
            NN_RESULT_THROW(ResultInternalAlbumStreamCountLimit());
        }

        // @pre value != InvalidValue
        nn::Result Unregister(ValueType value) NN_NOEXCEPT
        {
            NN_SDK_REQUIRES_NOT_EQUAL(value, ValueType::GetInvalidValue());
            for(int i = 0; i < Capacity; i++)
            {
                if(m_Table[i] == value)
                {
                    m_Table[i] = ValueType::GetInvalidValue();
                    NN_RESULT_SUCCESS;
                }
            }
            NN_RESULT_THROW(ResultInternalAlbumStreamNotFound());
        }

        bool GetHead(ValueType* pOutValue) const NN_NOEXCEPT
        {
            NN_SDK_REQUIRES_NOT_NULL(pOutValue);
            for(int i = 0; i < Capacity; i++)
            {
                if(m_Table[i] != ValueType::GetInvalidValue())
                {
                    *pOutValue = m_Table[i];
                    return true;
                }
            }
            return false;
        }

        bool Contains(ValueType value) const NN_NOEXCEPT
        {
            if(value == ValueType::GetInvalidValue())
            {
                return false;
            }

            for(int i = 0; i < Capacity; i++)
            {
                if(m_Table[i] == value)
                {
                    return true;
                }
            }

            return false;
        }

    private:
        ValueType m_Table[Capacity];
    };

}}}}
