﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>
#include <nn/util/util_BitFlagSet.h>
#include "../capsrvServer_Config.h"
#include "../capsrvServer_SessionId.h"
#include "capsrvServer_AlbumFileManipulator.h"
#include "capsrvServer_MovieStreamId.h"
#include "capsrvServer_TemporaryFileManipulator.h"
#include "capsrvServer_AlbumMovieUtility.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    enum MovieReadStreamState
    {
        MovieReadStreamState_Unused = 0,
        MovieReadStreamState_Reading,
        MovieReadStreamState_Broken,
    };

    class MovieReadStreamEntry
    {
    private:
        typedef AlbumMovieUtility::MetaHashList MetaHashList;

    public:
        MovieReadStreamEntry() NN_NOEXCEPT;

        MovieReadStreamState GetState() const NN_NOEXCEPT;
        SessionId GetClientSessionId() const NN_NOEXCEPT;
        MovieStreamId GetStreamId() const NN_NOEXCEPT;
        const AlbumFileId& GetAlbumFileId() const NN_NOEXCEPT;
        bool IsBroken() const NN_NOEXCEPT;
        nn::Result GetBrokenReason() const NN_NOEXCEPT;

        void NotifyStorageUnmounted(AlbumStorageType storage) NN_NOEXCEPT;

        nn::Result OpenFile(
            SessionId clientSessionId,
            MovieStreamId streamId,
            const AlbumFileId& fileId,
            void* workMemory,
            size_t workMemorySize,
            const EnvironmentInfo& env
        ) NN_NOEXCEPT;
        void CloseFile() NN_NOEXCEPT;

        nn::Result ReadMovieData(size_t* pOutReadSize, void* buffer, size_t size, int64_t offset, const EnvironmentInfo& env) NN_NOEXCEPT;
        nn::Result GetMovieDataSize(int64_t* pOutValue) const NN_NOEXCEPT;

        nn::Result ReadImageData(size_t* pOutReadSize, void* buffer, size_t size, int64_t offset, const EnvironmentInfo& env, void* workMemory, size_t workMemorySize) NN_NOEXCEPT;
        nn::Result GetImageDataSize(int64_t* pOutValue) const NN_NOEXCEPT;

    private:
        void MarkAsBroken(nn::Result brokenReason) NN_NOEXCEPT;
        // result.IsFailure() なら MarkBroken を呼び出す
        // @return result の値をそのまま返す。
        nn::Result MarkAsBrokenIfFailure(nn::Result result) NN_NOEXCEPT;

        // @post FileHandle が無効
        // @post IsFileOpened == false
        // @details IsFileOpened == false の場合、何もしない
        void CloseFileInternal() NN_NOEXCEPT;

    private:
        MovieReadStreamState m_State;
        nn::Result      m_BrokenReason;

        SessionId       m_ClientSessionId;
        MovieStreamId   m_StreamId;
        AlbumFileId     m_FileId;

        AlbumFileHandle m_FileHandle;
        TemporaryFileHandle m_DataHashFileHandle;
        bool            m_IsFileOpened;

        MetaHashList    m_MetaHashList;
        int64_t         m_MovieDataBlockCount;
        int64_t         m_MovieDataOffset;
        int64_t         m_MovieDataSize;
        int64_t         m_ImageDataOffset;
        int64_t         m_ImageDataSize;
    };

}}}}
