﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>
#include <nn/capsrv/capsrv_ScreenShotAttribute.h>
#include <nn/capsrv/capsrv_ScreenShotDecodeOption.h>
#include "capsrvServer_AlbumManager.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    nn::Result LoadAndDecodeScreenShot(
        int* pOutImageWidth,
        int* pOutImageHeight,
        ScreenShotAttribute* pOutAttribute,
        AppletData* pOutAppletData,
        ApplicationData* pOutApplicationData,
        SystemReservedInfo* pOutSystemReservedInfo,
        void *pImageBuffer,
        size_t imageBufferSize,
        void* pFileDataBuffer,
        size_t fileDataBufferSize,
        const AlbumFileId& fileId,
        const ScreenShotDecodeOption& option,
        AlbumManager* pAlbumManager
    ) NN_NOEXCEPT;

    nn::Result LoadAndDecodeScreenShotThumbnail(
        int* pOutImageWidth,
        int* pOutImageHeight,
        ScreenShotAttribute* pOutAttribute,
        AppletData* pOutAppletData,
        ApplicationData* pOutApplicationData,
        SystemReservedInfo* pOutSystemReservedInfo,
        void *pImageBuffer,
        size_t imageBufferSize,
        void* pThumbDataBuffer,
        size_t thumbDataBufferSize,
        const AlbumFileId& fileId,
        const ScreenShotDecodeOption& option,
        AlbumManager* pAlbumManager
    ) NN_NOEXCEPT;

}}}}
