﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/capsrv/capsrv_AlbumCacheData.h>
#include <nn/capsrv/capsrv_AlbumStorage.h>
#include <nn/capsrv/capsrv_AlbumFileContents.h>
#include "../capsrvServer_Config.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    class AlbumCacheDelta
    {
    public:
        AlbumCacheDelta() NN_NOEXCEPT;

        // @pre <= storage < AlbumStorageCount
        AlbumCacheDelta(AlbumStorageType storage, AlbumFileContentsType contents, int64_t fileCount) NN_NOEXCEPT;

        AlbumStorageType GetStorage() const NN_NOEXCEPT;
        AlbumFileContentsType GetContents() const NN_NOEXCEPT;
        int64_t GetFileCount() const NN_NOEXCEPT;

    private:
        AlbumStorageType m_Storage;
        AlbumFileContentsType m_Contents;
        int64_t          m_FileCount;
    };

    class AlbumStorageCache
    {
    public:
        typedef AlbumCacheData Entry;

    public:
        AlbumStorageCache() NN_NOEXCEPT;

        // @pre 0 <= storage < AlbumStorageCount
        void SetEntry(AlbumStorageType storage, AlbumFileContentsType contents, const Entry& entry) NN_NOEXCEPT;

        // @pre 0 <= delta.storage < AlbumStorageCount
        void UpdateEntry(const AlbumCacheDelta& delta) NN_NOEXCEPT;

        // @pre 0 <= storage < AlbumStorageCount
        Entry GetEntry(AlbumStorageType storage, AlbumFileContentsType contents) const NN_NOEXCEPT;

    private:
        Entry m_EntryList[AlbumStorageCount][FileContentsCount];
    };

}}}}
