﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_AlbumStorageCache.h"

#include <cstdlib>
#include <nn/nn_SdkAssert.h>
#include <nn/capsrv/capsrv_AlbumStorage.h>
#include "capsrvServer_AlbumPathUtility.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    AlbumCacheDelta::AlbumCacheDelta() NN_NOEXCEPT
    {
        std::memset(this, 0, sizeof(*this));
    }

    AlbumCacheDelta::AlbumCacheDelta(AlbumStorageType storage, AlbumFileContentsType contents, int64_t fileCount) NN_NOEXCEPT
        : m_Storage(storage)
        , m_Contents(contents)
        , m_FileCount(fileCount)
    {
        NN_SDK_ASSERT_RANGE(storage, 0, AlbumStorageCount);
        NN_SDK_ASSERT_RANGE(contents, 0, FileContentsCount);
    }

    AlbumStorageType AlbumCacheDelta::GetStorage() const NN_NOEXCEPT
    {
        return m_Storage;
    }

    AlbumFileContentsType AlbumCacheDelta::GetContents() const NN_NOEXCEPT
    {
        return m_Contents;
    }

    int64_t AlbumCacheDelta::GetFileCount() const NN_NOEXCEPT
    {
        return m_FileCount;
    }

    //------------------------------------------------------------

    AlbumStorageCache::AlbumStorageCache() NN_NOEXCEPT
    {
        std::memset(m_EntryList, 0, sizeof(m_EntryList));
    }

    void AlbumStorageCache::SetEntry(AlbumStorageType storage, AlbumFileContentsType contents, const Entry& entry) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_RANGE(storage, 0, AlbumStorageCount);
        NN_SDK_ASSERT_RANGE(contents, 0, FileContentsCount);
        if(storage < 0 || storage >= AlbumStorageCount)
        {
            return;
        }
        if(contents < 0 || contents >= FileContentsCount)
        {
            return;
        }
        m_EntryList[storage][contents] = entry;
    }

    void AlbumStorageCache::UpdateEntry(const AlbumCacheDelta& delta) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_RANGE(delta.GetStorage(), 0, AlbumStorageCount);
        NN_SDK_ASSERT_RANGE(delta.GetContents(), 0, FileContentsCount);
        if(delta.GetStorage() < 0 || delta.GetStorage() >= AlbumStorageCount)
        {
            return;
        }
        if(delta.GetContents() < 0 || delta.GetContents() >= FileContentsCount)
        {
            return;
        }
        m_EntryList[delta.GetStorage()][delta.GetContents()].fileCount += delta.GetFileCount();
    }

    AlbumStorageCache::Entry AlbumStorageCache::GetEntry(AlbumStorageType storage, AlbumFileContentsType contents) const NN_NOEXCEPT
    {
        NN_SDK_ASSERT_RANGE(storage, 0, AlbumStorageCount);
        NN_SDK_ASSERT_RANGE(contents, 0, FileContentsCount);
        if(storage < 0 || storage >= AlbumStorageCount)
        {
            return {};
        }
        if(contents < 0 || contents >= FileContentsCount)
        {
            return {};
        }
        return m_EntryList[storage][contents];
    }


}}}}

