﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nvrm_surface.h>
#include <nvgr.h>

#include "../capsrv_ImageFormat.h"

namespace nn{ namespace capsrv{ namespace capture{ namespace detail{

    class ImageFormatInfo
    {
    public:
        static uint32_t GetComposerImageFormat(ImageFormat format) NN_NOEXCEPT
        {
            switch(format)
            {
            case ImageFormat_Rgba8:
            case ImageFormat_SharedTexture:
                return android::PIXEL_FORMAT_RGBA_8888;
            case ImageFormat_Yuv444_Bt601_Planar:
                return NVGR_PIXEL_FORMAT_YUV444 | NVGR_PIXEL_FORMAT_601_ER;
            case ImageFormat_Yuv422_Bt601_Planar:
                return NVGR_PIXEL_FORMAT_YUV422_PITCH | NVGR_PIXEL_FORMAT_601_ER;
            case ImageFormat_Yuv440_Bt601_Planar:
                return NVGR_PIXEL_FORMAT_YUV422R | NVGR_PIXEL_FORMAT_601_ER;
            case ImageFormat_Yuv420_Bt601_Planar:
                return NVGR_PIXEL_FORMAT_YUV420_PITCH | NVGR_PIXEL_FORMAT_601_ER;
            default: NN_UNEXPECTED_DEFAULT;
            }
        }

        static NvColorFormat GetNvColorFormat(ImageFormat format) NN_NOEXCEPT
        {
            switch(format)
            {
            case ImageFormat_Rgba8:
            case ImageFormat_SharedTexture:
                return NvColorFormat_A8B8G8R8; // バイトオーダー的に逆になっている
            case ImageFormat_Y_Bt601:
                return NvColorFormat_Y8_ER; // BT.601
            case ImageFormat_U_Bt601:
                return NvColorFormat_U8_ER; // BT.601
            case ImageFormat_V_Bt601:
                return NvColorFormat_V8_ER; // BT.601
            case ImageFormat_Y_NV12:
                return NvColorFormat_Y8_709; // BT.709
            case ImageFormat_Uv_NV12:
                return NvColorFormat_U8_V8_709; // BT.709
            default: NN_UNEXPECTED_DEFAULT;
            }
        }

        static NvRmSurfaceLayout GetNvRmSurfaceLayout(ImageFormat format) NN_NOEXCEPT
        {
            switch(format)
            {
            case ImageFormat_Y_NV12:
            case ImageFormat_Uv_NV12:
            case ImageFormat_SharedTexture:
                return NvRmSurfaceLayout_Blocklinear;
            default:
                return NvRmSurfaceLayout_Pitch;
            }
        }

        static int GetNvRmBlockHeightLog2(ImageFormat format) NN_NOEXCEPT
        {
            switch(format)
            {
            case ImageFormat_Y_NV12:
            case ImageFormat_Uv_NV12:
                return 1;
            default:
                return -1; // 負の場合、既定値を使う。
            }
        }

        static int GetPixelSize(ImageFormat format) NN_NOEXCEPT
        {
            switch(format)
            {
            case ImageFormat_Y_Bt601:
            case ImageFormat_U_Bt601:
            case ImageFormat_V_Bt601:
            case ImageFormat_Y_NV12:
                return 1;
            case ImageFormat_Uv_NV12:
                return 2;
            case ImageFormat_Rgba8:
            case ImageFormat_SharedTexture:
                return 4;
            default: NN_UNEXPECTED_DEFAULT;
            }
        }

    };

}}}}

