﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nvrm_memmgr.h>
#include "capsrv_MemoryPool.h"

namespace nn{ namespace capsrv{ namespace capture{

    class MemoryPoolData
    {
    public:
        enum State
        {
            State_NotInitialized = 0,
            State_Initialized,
            State_Imported,
        };

    public:
        static size_t GetRequiredAlignment() NN_NOEXCEPT;
        static size_t GetRequiredUnitSize() NN_NOEXCEPT;

        MemoryPoolData() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;

        nn::Result Initialize(CaptureModule* pModule, void* pMemory, size_t size) NN_NOEXCEPT;
        nn::Result InitializeAsImported(const MemoryPoolImportData& src) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        NvRmMemHandle GetHandle() const NN_NOEXCEPT;
        uintptr_t GetMemoryAddress() const NN_NOEXCEPT;

    private:
        State         m_State;
        NvRmMemHandle m_hMemory;
        void*         m_pMemory;
        size_t        m_Size;
    };

}}}
