﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrv_ImageBuffer.h"
#include "capsrv_ImageBuffer-module.stub.h"

#include <new>
#include <cstring>
#include <nn/nn_SdkAssert.h>

namespace nn{ namespace capsrv{ namespace capture{

    ImageBuffer::ImageBuffer() NN_NOEXCEPT
    {
        NN_CAPSRV_CAPTURE_DATASTORAGE_CHECK(DataType, m_DataStorage);
        std::memset(this, 0, sizeof(*this));
    }

    size_t ImageBuffer::GetRequiredMemorySize(const InfoType& info) NN_NOEXCEPT
    {
        return ImageBufferData::GetRequiredMemorySize(info);
    }

    size_t ImageBuffer::GetRequiredMemoryAlignment(CaptureModule* pModule, const InfoType& info) NN_NOEXCEPT
    {
        return ImageBufferData::GetRequiredMemoryAlignment(pModule, info);
    }

    nn::Result ImageBuffer::Initialize(CaptureModule* pModule, const InfoType& info, MemoryPool* pMemoryPool, ptrdiff_t offset, size_t size) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());
        m_pData = new(&m_DataStorage) DataType();
        return m_pData->Initialize(pModule, info, pMemoryPool, offset, size);
    }

    void ImageBuffer::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->Finalize();
        m_pData->~DataType();
        m_pData = nullptr;
    }

    void ImageBuffer::FlushCache() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->FlushCache();
    }

    ImageFormat ImageBuffer::GetImageFormat() const NN_NOEXCEPT
    {
        return m_pData->GetImageFormat();
    }

    nn::Result ImageBuffer::WriteToMemory(
        size_t* pOutSize,
        void* pBuffer,
        size_t bufferSize,
        ImageFormat dstFormat,
        const Rectangle* pSrcRectangle
        ) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pData->WriteToMemory(pOutSize, pBuffer, bufferSize, dstFormat, pSrcRectangle);
    }

}}}
