﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/vi/vi_LayerStack.h>

#include "capsrv_CaptureConfig.h"
#include "capsrv_ImageFormat.h"
#include "capsrv_CaptureModule.h"
#include "capsrv_ImageBuffer.h"
#include "capsrv_DisplayBuffer.h"

namespace nn{ namespace capsrv{ namespace capture{

    class DisplayCaptureData;

    class DisplayCapture
    {
    public:
        static const int BufferCount = 1;
    public:
        typedef DisplayCaptureData DataType;
        typedef DisplayCaptureDataStorageType DataStorageType;
    public:
        DisplayCapture() NN_NOEXCEPT;

        void Initialize(
            CaptureModule* pModule,
            const char* name,
            nn::vi::LayerStack layerStack,
            int width,
            int height,
            ImageFormat format
            ) NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        void SetCaptureBuffer(int index, DisplayBuffer* pBuffer) NN_NOEXCEPT;

        // @pre !IsRecoveryRequired
        void UnsetCaptureBuffer(int index) NN_NOEXCEPT;

        DisplayBuffer* AcquireCaptureBuffer(nn::TimeSpan timeout) NN_NOEXCEPT;
        DisplayBuffer* AcquireCaptureBuffer(nn::TimeSpan timeout, vi::LayerStack layerStack) NN_NOEXCEPT;
        DisplayBuffer* AcquireCaptureBuffer(nn::TimeSpan timeout, vi::LayerStack layerStack, int width, int height) NN_NOEXCEPT;
        void ReleaseCaptureBuffer(DisplayBuffer* pBuffer) NN_NOEXCEPT;

        bool IsRecoveryRequired() const NN_NOEXCEPT;
        bool RecoverCapture(nn::TimeSpan timeout) NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT { return m_pData != nullptr; }
        DataType* GetData() NN_NOEXCEPT { return m_pData; }
        const DataType* GetData() const NN_NOEXCEPT { return m_pData; }

    private:
        DataType* m_pData;
        DataStorageType m_DataStorage;
    };
}}}
