﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "capsrv_CaptureConfig.h"
#include "capsrv_CaptureModule.h"
#include "capsrv_ImageFormat.h"
#include "capsrv_Rectangle.h"
#include "capsrv_ImageBuffer.h"
#include "capsrv_FilterMode.h"

namespace nn{ namespace capsrv{ namespace capture{
    class DisplayBufferData;

    class DisplayBuffer
    {
    public:
        typedef DisplayBufferData DataType;
        typedef DisplayBufferDataStorageType DataStorageType;
    public:
        DisplayBuffer() NN_NOEXCEPT;

        // RGBA 用
        void InitializeRgba(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBuffer) NN_NOEXCEPT;
        // YUV(Planar) 用
        void InitializeYuvPlanar(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBufferY, ImageBuffer* pBufferU, ImageBuffer* pBufferV) NN_NOEXCEPT;
        // YUV(SemiPlanar) 用
        void InitializeYuvSemiPlanar(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBufferY, ImageBuffer* pBufferUv) NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        ImageFormat GetImageFormat() const NN_NOEXCEPT;

        const ImageBuffer* GetImageBuffer() const NN_NOEXCEPT;
        void GetImageBufferYuvPlanar(const ImageBuffer** pOutBufferY, const ImageBuffer** pOutBufferU, const ImageBuffer** pOutBufferV) const NN_NOEXCEPT;
        void GetImageBufferYuvPlanar(ImageBuffer** pOutBufferY, ImageBuffer** pOutBufferU, ImageBuffer** pOutBufferV) NN_NOEXCEPT;
        void FlushCache() const NN_NOEXCEPT;

        // バッファの内容が自明かどうかを返します。
        // 1 枚もバッファが合成されなかった場合、バッファの内容は自明となります。
        bool IsContentTrivial() const NN_NOEXCEPT;

        nn::Result CopyToImageBuffer(
            ImageBuffer* pDstBuffer,
            CaptureModule* pModule,
            const Rectangle* pDstRect,
            FilterMode filterMode
        ) const NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT { return m_pData != nullptr; }
        DataType* GetData() NN_NOEXCEPT { return m_pData; }
        const DataType* GetData() const NN_NOEXCEPT { return m_pData; }

    private:
        DataType* m_pData;
        DataStorageType m_DataStorage;
    };

}}}
