﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "capsrv_DisplayBuffer.h"

#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include "capsrv_ImageFormat.h"

namespace nn{ namespace capsrv{ namespace capture{

    class DisplayBufferData
    {
    public:
        void InitializeRgba(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBuffer) NN_NOEXCEPT
        {
            m_pModule = pModule;
            m_Format = format;
            m_pBuffer[0] = pBuffer;
            m_BufferCount = 1;
        }

        void InitializeYuvPlanar(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBufferY, ImageBuffer* pBufferU, ImageBuffer* pBufferV) NN_NOEXCEPT
        {
            m_pModule = pModule;
            m_Format = format;
            m_pBuffer[0] = pBufferY;
            m_pBuffer[1] = pBufferU;
            m_pBuffer[2] = pBufferV;
            m_BufferCount = 3;
        }

        void InitializeYuvSemiPlanar(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBufferY, ImageBuffer* pBufferUv) NN_NOEXCEPT
        {
            m_pModule = pModule;
            m_Format = format;
            m_pBuffer[0] = pBufferY;
            m_pBuffer[1] = pBufferUv;
            m_BufferCount = 2;
        }

        void Finalize() NN_NOEXCEPT
        {
        }

        const ImageBuffer* GetImageBuffer() const NN_NOEXCEPT
        {
            return m_pBuffer[0];
        }

        void GetImageBufferYuvPlanar(const ImageBuffer** pOutBufferY, const ImageBuffer** pOutBufferU, const ImageBuffer** pOutBufferV) const NN_NOEXCEPT
        {
            *pOutBufferY = m_pBuffer[0];
            *pOutBufferU = m_pBuffer[1];
            *pOutBufferV = m_pBuffer[2];
        }

        void GetImageBufferYuvPlanar(ImageBuffer** pOutBufferY, ImageBuffer** pOutBufferU, ImageBuffer** pOutBufferV) NN_NOEXCEPT
        {
            *pOutBufferY = m_pBuffer[0];
            *pOutBufferU = m_pBuffer[1];
            *pOutBufferV = m_pBuffer[2];
        }

        void FlushCache() const NN_NOEXCEPT
        {
        }

        bool IsContentTrivial() const NN_NOEXCEPT
        {
            return false;
        }

        nn::Result CopyToImageBuffer(
            ImageBuffer* pDstBuffer,
            CaptureModule* pModule,
            const Rectangle* pDstRect,
            FilterMode filterMode
        ) const NN_NOEXCEPT
        {
            NN_UNUSED(pDstBuffer);
            NN_UNUSED(pModule);
            NN_UNUSED(pDstRect);
            NN_UNUSED(filterMode);
            NN_RESULT_SUCCESS;
        }

    public:
        CaptureModule* m_pModule;
        ImageFormat m_Format;
        ImageBuffer* m_pBuffer[3];
        int m_BufferCount;
    };

}}}
