﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrv_DisplayBuffer.h"
#include "capsrv_DisplayBuffer-module.stub.h"

#include <new>
#include <nn/nn_SdkAssert.h>

namespace nn{ namespace capsrv{ namespace capture{

    //------------------------------------
    // Interface
    //------------------------------------

    DisplayBuffer::DisplayBuffer() NN_NOEXCEPT
    {
        NN_CAPSRV_CAPTURE_DATASTORAGE_CHECK(DataType, m_DataStorage);
        std::memset(this, 0, sizeof(*this));
    }

    void DisplayBuffer::InitializeRgba(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBuffer) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());
        m_pData = new(&m_DataStorage) DataType();

        return m_pData->InitializeRgba(pModule, format, pBuffer);
    }

    void DisplayBuffer::InitializeYuvPlanar(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBufferY, ImageBuffer* pBufferU, ImageBuffer* pBufferV) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());
        m_pData = new(&m_DataStorage) DataType();

        return m_pData->InitializeYuvPlanar(pModule, format, pBufferY, pBufferU, pBufferV);
    }

    void DisplayBuffer::InitializeYuvSemiPlanar(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBufferY, ImageBuffer* pBufferUv) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());
        m_pData = new(&m_DataStorage) DataType();

        return m_pData->InitializeYuvSemiPlanar(pModule, format, pBufferY, pBufferUv);
    }

    void DisplayBuffer::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->Finalize();
        m_pData->~DataType();
        m_pData = nullptr;
    }

    ImageFormat DisplayBuffer::GetImageFormat() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pData->m_Format;
    }

    const ImageBuffer* DisplayBuffer::GetImageBuffer() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pData->GetImageBuffer();
    }

    void DisplayBuffer::GetImageBufferYuvPlanar(
        const ImageBuffer** pOutBufferY,
        const ImageBuffer** pOutBufferU,
        const ImageBuffer** pOutBufferV
    ) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->GetImageBufferYuvPlanar(pOutBufferY, pOutBufferU, pOutBufferV);
    }

    void DisplayBuffer::GetImageBufferYuvPlanar(
        ImageBuffer** pOutBufferY,
        ImageBuffer** pOutBufferU,
        ImageBuffer** pOutBufferV
    ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->GetImageBufferYuvPlanar(pOutBufferY, pOutBufferU, pOutBufferV);
    }

    void DisplayBuffer::FlushCache() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(m_pData);
        m_pData->FlushCache();
    }

    bool DisplayBuffer::IsContentTrivial() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(m_pData);
        return m_pData->IsContentTrivial();
    }

    nn::Result DisplayBuffer::CopyToImageBuffer(
        ImageBuffer* pDstBuffer,
        CaptureModule* pModule,
        const Rectangle* pDstRect,
        FilterMode filterMode
        ) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pData->CopyToImageBuffer(pDstBuffer, pModule, pDstRect, filterMode);
    }

}}}
