﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>

namespace nn{ namespace capsrv{

    class LibraryState
    {
    public:
        enum ServiceLevel
        {
            ServiceLevel_None,
            ServiceLevel_AlbumAccess,
            ServiceLevel_AlbumControl,
        };
        typedef nn::sf::SharedPointer<nn::capsrv::sf::IMovieReadStreamServiceObject> MovieReadStreamServicePointerType;
        typedef nn::sf::SharedPointer<nn::capsrv::sf::IMovieWriteStreamServiceObject> MovieWriteStreamServicePointerType;

    public:
        static nn::applet::AppletResourceUserId GetMyAruid() NN_NOEXCEPT;

        LibraryState() NN_NOEXCEPT;

        nn::sf::SharedPointer<nn::capsrv::sf::IMovieReadStreamServiceObject> GetMovieReadStreamSession() NN_NOEXCEPT;
        nn::Result SetMovieReadStreamSession(nn::sf::SharedPointer<nn::capsrv::sf::IMovieReadStreamServiceObject> p, ServiceLevel level) NN_NOEXCEPT;

        nn::sf::SharedPointer<nn::capsrv::sf::IMovieWriteStreamServiceObject> GetMovieWriteStreamSession() NN_NOEXCEPT;
        nn::Result SetMovieWriteStreamSession(nn::sf::SharedPointer<nn::capsrv::sf::IMovieWriteStreamServiceObject> p, ServiceLevel level) NN_NOEXCEPT;

    private:
        nn::sf::SharedPointer<nn::capsrv::sf::IMovieReadStreamServiceObject> m_pMovieReadStreamSession;
        ServiceLevel m_MovieReadStreamSessionServiceLevel;

        nn::sf::SharedPointer<nn::capsrv::sf::IMovieWriteStreamServiceObject> m_pMovieWriteStreamSession;
        ServiceLevel m_MovieWriteStreamSessionServiceLevel;

    };

    extern LibraryState g_LibraryState;

}}
