﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{ namespace assertion{

    typedef int64_t SintType;
    typedef uint64_t UintType;

    template<typename T> T CheckType2(T a, T b) NN_NOEXCEPT;
    template<typename T> T CheckType3(T a, T b, T c) NN_NOEXCEPT;

}}}

#define NN_CAPSRV_CHECK_TYPE2(a,b)   NN_STATIC_ASSERT(sizeof(nn::capsrv::assertion::CheckType2(a,b)))
#define NN_CAPSRV_CHECK_TYPE3(a,b,c) NN_STATIC_ASSERT(sizeof(nn::capsrv::assertion::CheckType3(a,b,c)))

#define NN_CAPSRV_ASSERT_BASE NN_SDK_ASSERT
#define NN_CAPSRV_ASSERT_IMPL_I(x) x
#define NN_CAPSRV_ASSERT_IMPL(TYPE) NN_SDK_ASSERT_ ## TYPE

#define NN_CAPSRV_REQUIRES_BASE NN_SDK_REQUIRES
#define NN_CAPSRV_REQUIRES_IMPL_I(x) x
#define NN_CAPSRV_REQUIRES_IMPL(TYPE) NN_SDK_REQUIRES_ ## TYPE

#define NN_CAPSRV_ASSERT                            NN_CAPSRV_ASSERT_BASE
#define NN_CAPSRV_ASSERT_NOT_NULL(pointer)          NN_CAPSRV_ASSERT_IMPL(NOT_NULL) (pointer)
#define NN_CAPSRV_ASSERT_ALIGNED(pointer,align)     NN_CAPSRV_ASSERT_IMPL(ALIGNED) (pointer, align)
#define NN_CAPSRV_ASSERT_EQUAL(lhs,rhs)             NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_ASSERT_IMPL(EQUAL) (lhs,rhs)
#define NN_CAPSRV_ASSERT_LESS(lhs,rhs)              NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_ASSERT_IMPL(LESS) (lhs,rhs)
#define NN_CAPSRV_ASSERT_LESS_EQUAL(lhs,rhs)        NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_ASSERT_IMPL(LESS_EQUAL) (lhs,rhs)
#define NN_CAPSRV_ASSERT_GREATER(lhs,rhs)           NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_ASSERT_IMPL(GREATER) (lhs,rhs)
#define NN_CAPSRV_ASSERT_GREATER_EQUAL(lhs,rhs)     NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_ASSERT_IMPL(GREATER_EQUAL) (lhs,rhs)
#define NN_CAPSRV_ASSERT_STRING_EQUAL(lhs, rhs)     NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_ASSERT_IMPL(STRING_EQUAL) (pointer,align)
#define NN_CAPSRV_ASSERT_STRING_NOT_EQUAL(lhs, rhs) NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_ASSERT_IMPL(STRING_NOT_EQUAL) (pointer,align)
#define NN_CAPSRV_ASSERT_RANGE(value,begin,end)     NN_CAPSRV_CHECK_TYPE3(value, begin, end); NN_CAPSRV_ASSERT_IMPL(RANGE) (value, begin, end)
#define NN_CAPSRV_ASSERT_MINMAX(value,min,max)      NN_CAPSRV_CHECK_TYPE3(value, min, max);   NN_CAPSRV_ASSERT_IMPL(MINMAX) (value, begin, end)

#define NN_CAPSRV_REQUIRES                            NN_CAPSRV_REQUIRES_BASE
#define NN_CAPSRV_REQUIRES_NOT_NULL(pointer)          NN_CAPSRV_REQUIRES_IMPL(NOT_NULL) (pointer)
#define NN_CAPSRV_REQUIRES_ALIGNED(pointer,align)     NN_CAPSRV_REQUIRES_IMPL(ALIGNED) (pointer, align)
#define NN_CAPSRV_REQUIRES_EQUAL(lhs,rhs)             NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_REQUIRES_IMPL(EQUAL) (lhs,rhs)
#define NN_CAPSRV_REQUIRES_LESS(lhs,rhs)              NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_REQUIRES_IMPL(LESS) (lhs,rhs)
#define NN_CAPSRV_REQUIRES_LESS_EQUAL(lhs,rhs)        NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_REQUIRES_IMPL(LESS_EQUAL) (lhs,rhs)
#define NN_CAPSRV_REQUIRES_GREATER(lhs,rhs)           NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_REQUIRES_IMPL(GREATER) (lhs,rhs)
#define NN_CAPSRV_REQUIRES_GREATER_EQUAL(lhs,rhs)     NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_REQUIRES_IMPL(GREATER_EQUAL) (lhs,rhs)
#define NN_CAPSRV_REQUIRES_STRING_EQUAL(lhs, rhs)     NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_REQUIRES_IMPL(STRING_EQUAL) (pointer,align)
#define NN_CAPSRV_REQUIRES_STRING_NOT_EQUAL(lhs, rhs) NN_CAPSRV_CHECK_TYPE2(lhs, rhs); NN_CAPSRV_REQUIRES_IMPL(STRING_NOT_EQUAL) (pointer,align)
#define NN_CAPSRV_REQUIRES_RANGE(value,begin,end)     NN_CAPSRV_CHECK_TYPE3(value, begin, end); NN_CAPSRV_REQUIRES_IMPL(RANGE) (value, begin, end)
#define NN_CAPSRV_REQUIRES_MINMAX(value,min,max)      NN_CAPSRV_CHECK_TYPE3(value, min, max);   NN_CAPSRV_REQUIRES_IMPL(MINMAX) (value, begin, end)
