﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "capsrv_ServiceHolderBase.h"

namespace nn{ namespace capsrv{

    class AlbumAccessServiceHolder
        : public ServiceHolderBase<
            AlbumAccessServiceHolder,
            nn::capsrv::sf::IAlbumAccessorService,
            4 /* ObjectCountMax */,
            SessionHolder<nn::capsrv::sf::IAlbumAccessorSession>
          >
    {
    public:
        static const char* GetServiceName() NN_NOEXCEPT { return sf::AlbumAccessorServiceName; }
    };

    extern AlbumAccessServiceHolder g_AlbumAccessServiceHolder;

}}
