﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/album/album_ImageSize.h>

#include <nn/album/album_Result.h>

namespace nn{ namespace album{

    int GetImageWidth(ImageSize size) NN_NOEXCEPT
    {
        switch(size)
        {
        case ImageSize_1280x720:
            return 1280;
        default: NN_UNEXPECTED_DEFAULT;
        }
    }

    int GetImageHeight(ImageSize size) NN_NOEXCEPT
    {
        switch(size)
        {
        case ImageSize_1280x720:
            return 720;
        default: NN_UNEXPECTED_DEFAULT;
        }
    }

}}
