﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/album/album_ExtraMediaFileAccess.private.h>
#include <nn/album/album_Result.h>

#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkAssert.h>
#include <nn/time/time_TimeZoneApi.h>
#include <nn/capsrv/capsrv_AlbumAccessForApplication.h>
#include <nn/capsrv/capsrv_AlbumFileContents.h>

#include "album_Log.h"
#include "album_LibraryState.h"

#include <cstring>

namespace nn { namespace album {

// アルバム内ファイルリストの取得
Result GetExtraMovieFileList(int* pOutCount, AlbumFileEntry buffer[], int bufferLength) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutCount);
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES_ALIGNED(buffer, NN_ALIGNOF(AlbumFileEntry));
    NN_SDK_REQUIRES_GREATER(bufferLength, 0);

    NN_SDK_REQUIRES(g_LibraryState.IsInitialized());
    g_LibraryState.EnsureAlbumAvailable();

    auto result = capsrv::GetAlbumContentsFileListForApplication(pOutCount, reinterpret_cast<capsrv::ApplicationAlbumFileEntry*>(buffer), bufferLength, capsrv::AlbumFileContents_ExtraMovie, capsrv::AlbumFileDateTimeMin, capsrv::AlbumFileDateTimeMax);
    if (!result.IsSuccess())
    {
        *pOutCount = 0;
    }
    NN_RESULT_SUCCESS;
}

// アルバム内ファイルの削除
Result DeleteExtraMovieFile(const AlbumFileEntry& entry) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(&entry);

    NN_SDK_REQUIRES(g_LibraryState.IsInitialized());
    g_LibraryState.EnsureAlbumAvailable();

    capsrv::ApplicationAlbumFileEntry dstEntry;
    std::memcpy(&dstEntry, &entry, sizeof(dstEntry));
    auto result = capsrv::DeleteAlbumContentsFileForApplication(dstEntry, capsrv::AlbumFileContents_ExtraMovie);
    NN_RESULT_THROW_UNLESS(result.IsSuccess(), ResultAlbumFileNotFound());
    NN_RESULT_SUCCESS;
}

}}  // namespace nn::album
