﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/album/album_CommonApi.h>
#include <nn/album/album_SaveScreenshot.h>
#include <nn/album/album_SaveAndShareScreenshot.h>
#include <nn/album/album_GetSharePostedService.h>
#include <nn/album/album_GetSharePostedLastUrl.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/album/album_Result.h>

// album_CommonApi.h
namespace nn{ namespace album{

    void Initialize() NN_NOEXCEPT
    {
    }

    void Finalize() NN_NOEXCEPT
    {
    }

}}


// album_SaveScreenshot.h
// album_SaveAndShareScreenshot.h
namespace nn{ namespace album{

    nn::Result SaveScreenshot(
        const void* pImageData,
        size_t imageDataSize,
        ImageSize screenshotSize,
        AlbumReportOption reportOption
    ) NN_NOEXCEPT
    {
        NN_UNUSED(pImageData);
        NN_UNUSED(imageDataSize);
        NN_UNUSED(screenshotSize);
        NN_UNUSED(reportOption);
        NN_RESULT_THROW(ResultNotSupported());
    }

    nn::Result SaveScreenshot(
        const void* pImageData,
        size_t imageDataSize,
        ImageSize screenshotSize,
        ImageOrientation imageOrientation,
        AlbumReportOption reportOption
    ) NN_NOEXCEPT
    {
        NN_UNUSED(pImageData);
        NN_UNUSED(imageDataSize);
        NN_UNUSED(screenshotSize);
        NN_UNUSED(imageOrientation);
        NN_UNUSED(reportOption);
        NN_RESULT_THROW(ResultNotSupported());
    }
}}

// album_GetSharePostedService.h
// album_GetSharePostedLastUrl.h
namespace nn{ namespace album{

    int GetSharePostedServiceName(char* pOutBuffer, size_t bufferSize, const ShareId& shareId) NN_NOEXCEPT
    {
        NN_UNUSED(shareId);
        std::memset(pOutBuffer, 0, bufferSize);
        return 0;
    }

    int GetSharePostedEntryId(char* pOutBuffer, size_t bufferSize, const ShareId& shareId) NN_NOEXCEPT
    {
        NN_UNUSED(shareId);
        std::memset(pOutBuffer, 0, bufferSize);
        return 0;
    }

    int GetSharePostedLastUrl(char* pOutBuffer, size_t bufferSize, const ShareId& shareId) NN_NOEXCEPT
    {
        NN_UNUSED(shareId);
        std::memset(pOutBuffer, 0, bufferSize);
        return 0;
    }

}}
