﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/album/album_AlbumFileEntry.private.h>
#include <nn/capsrv/capsrv_AlbumFileDateTime.h>

namespace nn { namespace album {

struct AlbumFileIdImpl
{
    char _encryptedFileId[32];
};

struct NN_ALIGNAS(8) AlbumFileEntryImpl
{
    AlbumFileIdImpl         encrypted;      // 暗号化されたファイル識別子
    capsrv::AlbumFileDateTime dateTime;     // ファイルの作成日時の内部表現
    char                    reserved[8];    // 予約領域
};

NN_STATIC_ASSERT(NN_ALIGNOF(AlbumFileEntry) == NN_ALIGNOF(AlbumFileEntryImpl));
NN_STATIC_ASSERT(sizeof(AlbumFileEntry) == sizeof(AlbumFileEntryImpl));

}}  // namespace nn::album
