﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_NN_OS_EXCEPTIONI_H_
#define NW_WINEXT_NN_OS_EXCEPTIONI_H_


#if _MSC_VER >= 1500
#pragma once
#endif


namespace nw {
namespace internal {
namespace winext {

/*
    Win32 APIのエラーを表す例外クラス
*/
class Win32Exception
{
public:
                        Win32Exception(unsigned long errorCode)
                        : errorCode_(errorCode) {}

    unsigned long               GetErrorCode() const   { return errorCode_; }

private:
    unsigned long				errorCode_;
};


/*
    EGL のエラーを表す例外クラス
*/
class EglException
{
public:
                        EglException(int errorCode)
                        : errorCode_(errorCode) {}

    int                 GetErrorCode() const   { return errorCode_; }

private:
    int                 errorCode_;
};


void                ReportWin32Exception(const Win32Exception& ex);


}   // namespace winext {
}   // namespace internal {
}   // namespace nw


/*NW_WINEXT_NN_OS_EXCEPTIONI_H_*/
#endif
