﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <Windows.h>
#include <winext/cafe.h>

#include <winext/cafe/os/OSEvent.h>

namespace nw {
namespace internal {
namespace winext {

void OSInitEvent(OSEvent *event, BOOL initial_state, s32 mode)
{
    event->handle = CreateEvent(
        NULL,
        mode == OS_EVENT_MANUAL ? TRUE : FALSE,
        initial_state,
        NULL
        );
}

//void OSInitEventEx(OSEvent *event, BOOL initial_state, s32 mode, char * name);

void OSSignalEvent(OSEvent *event)
{
    SetEvent( event->handle );
}

//void OSSignalEventAll(OSEvent *event);

void OSWaitEvent(OSEvent *event)
{
    WaitForSingleObject( event->handle, INFINITE );
}

void OSResetEvent(OSEvent *event)
{
    ResetEvent( event->handle );
}

BOOL OSWaitEventWithTimeout(OSEvent *event, OSTimeNanoseconds timeout)
{
    DWORD dwResult = WaitForSingleObject( event->handle, static_cast<DWORD>(timeout*1000) );
    return dwResult == WAIT_OBJECT_0;
}

} // namespace winext
} // namespace internal
} // namespace nw

