﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <winext/types.h>
#include <winext/cafe/os/OSCore.h>

namespace nw {
namespace internal {
namespace winext {

/*---------------------------------------------------------------------------*
  Name:         OSGetCoreId

  Description:  Returns the currently running core's ID

  Arguments:    None.

  Returns:      Core ID number (0-2)
 *---------------------------------------------------------------------------*/

u32 OSGetCoreId()
{
    return 0;
}


/*---------------------------------------------------------------------------*
  Name:         OSIsMainCore

  Description:  Returns whether the current core is the main core

  Arguments:    None.

  Returns:      Core ID number (0-2)
 *---------------------------------------------------------------------------*/

BOOL OSIsMainCore()
{
    return (OSGetCoreId() == OSGetMainCoreId());
}


/*---------------------------------------------------------------------------*
  Name:         OSGetCoreCount

  Description:  Returns the count of running cores

  Arguments:    None.

  Returns:      Running core count
 *---------------------------------------------------------------------------*/

u32 OSGetCoreCount()
{
    return 1;
}

/*---------------------------------------------------------------------------*
  Name:         OSGetMainCoreId

  Description:  Returns the main core ID

  Arguments:    None.

  Returns:      Main core ID
 *---------------------------------------------------------------------------*/

u32 OSGetMainCoreId()
{
    return 0;
}

} // namespace winext
} // namespace internal
} // namespace nw
